/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.network;

import com.tom.storagemod.StorageMod;
import com.tom.storagemod.network.DataPacket;
import com.tom.storagemod.network.IDataReceiver;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("toms_storage", "main"), () -> "1", "1"::equals, "1"::equals);

    public static void init() {
        INSTANCE.registerMessage(0, DataPacket.class, DataPacket::toBytes, DataPacket::new, NetworkHandler::handleData);
        StorageMod.LOGGER.info("Initilaized Network Handler");
    }

    public static void handleData(DataPacket packet, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
                if (sender.field_71070_bA instanceof IDataReceiver) {
                    ((IDataReceiver)sender.field_71070_bA).receive(packet.tag);
                }
            });
        } else if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> {
                if (Minecraft.func_71410_x().field_71462_r instanceof IDataReceiver) {
                    ((IDataReceiver)Minecraft.func_71410_x().field_71462_r).receive(packet.tag);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }

    public static void sendDataToServer(CompoundNBT tag) {
        INSTANCE.sendToServer((Object)new DataPacket(tag));
    }

    public static void sendTo(ServerPlayerEntity pl, CompoundNBT tag) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> pl), (Object)new DataPacket(tag));
    }
}

